import { registerCommand } from '../register_commands.js';
import { assertClipboard } from './../../modules/assert.js';
import { Cardinal } from './../../modules/directions.js';
import { RawText, Vector } from './../../../library/Minecraft.js';
import { transformSelection } from './transform_func.js';
import { FAST_MODE } from './../../../config.js';
import { Jobs } from './../../modules/jobs.js';
const registerInformation = {
    name: 'flip',
    permission: 'worldedit.region.flip',
    description: 'commands.wedit:flip.description',
    usage: [
        {
            flag: 'o'
        },
        {
            flag: 'c'
        },
        {
            flag: 's'
        },
        {
            name: 'direction',
            type: 'Direction',
            default: new Cardinal(Cardinal.Dir.LEFT)
        }
    ]
};
const flipBits = {
    0b000: 'none', 0b001: 'x', 0b010: 'z', 0b011: 'xz',
    0b100: 'y', 0b101: 'xy', 0b110: 'yz', 0b111: 'xyz'
};
registerCommand(registerInformation, function* (session, builder, args) {
    const dir = args.get('direction').getDirection(builder);
    const flip = Vector.ONE;
    if (dir.x)
        flip.x *= -1;
    if (dir.y)
        flip.y *= -1;
    if (dir.z)
        flip.z *= -1;
    let blockCount = 0;
    // TODO: Support stacking rotations and flips
    if (args.has('c')) {
        assertClipboard(session);
        if (dir.y != 0 && !session.clipboard.isAccurate) {
            throw 'commands.wedit:flip.notLateral';
        }
        const clipTrans = session.clipboardTransform;
        if (!args.has('o')) {
            if (Math.abs(dir.x)) {
                clipTrans.relative.x *= -1;
            }
            else if (Math.abs(dir.z)) {
                clipTrans.relative.z *= -1;
            }
        }
        clipTrans.flip = clipTrans.flip.mul(flip);
        blockCount = session.clipboard.getBlockCount();
    }
    else {
        if (dir.y != 0 && FAST_MODE) {
            throw 'commands.wedit:flip.notLateral';
        }
        const job = Jobs.startJob(session, 3, null); // TODO: Add ticking area
        yield* Jobs.perform(job, transformSelection(session, builder, args, { flip }));
        Jobs.finishJob(job);
        blockCount = session.selection.getBlockCount();
    }
    return RawText.translate('commands.wedit:flip.explain').with(blockCount);
});
